#pragma warning ( 3 : 4706)
#include <windows.h>
#include "externs.h"
#include "defines.h"
#include "Init.h"
#include "Debug.h"

static int   InitGameSound();
static void  DeinitGameSound();

static int   InitGameInput();
static void  DeinitGameInput();

static int   InitGameGraphics();
static void  DeinitGameGraphics();

static void  KBCallback(CDIDevice *dev);
static void  MouseCallback(CDIDevice *dev);


/***** GLOBALS *****/
byte KeyboardBuf[256];
//int MouseX, MouseY, MouseBtn[3];
list<KeyPress>   KeyHistory;
list<MouseClick> ClickHistory;
volatile BOOL bInputFailure;
/***** GLOBALS *****/


int InitGame()
{
   int err;

   err = InitGameInput();
   if (err)
   {
      MsgBox("Error initializing input.");
      return err;
   }

/* DONT INIT SOUND
   err = InitGameSound();
   if (err)
   {
      MsgBox("Error initializing sound.");
      return err;
   }

   if (!MIDASsetOption(MIDAS_OPTION_MIXRATE, MIDASMIXRATE)) return 7;
   if (!MIDASsetOption(MIDAS_OPTION_OUTPUTMODE, MIDASOUTMODE)) return 8;
   if (!MIDASsetOption(MIDAS_OPTION_MIXING_MODE, MIDASQUALITY)) return 9;

   if (Cmidas .Init(g_hWnd, &Cdsound, 0))
   {
      DebugFOut2("InitGame:Cmidas.Init - %s", MIDASgetErrorMessage(MIDASgetLastError()));
      MsgBox("Error initializing music.");
      return 10;
   }
   BUT INIT GRAPHICS */

   err = InitGameGraphics();
   if (err)
   {
      MsgBox("Error initializing graphics.");
      return err;
   }

   bInputFailure = FALSE;

   return 0;
} /* InitGame */


int DeinitGame()
{
   DeinitGameSound();
   DeinitGameInput();
   DeinitGameGraphics();

   return 0;
} /* DeinitGame */


int InitGameSound()
{
   if (Cdsound.Init(g_hWnd, NULL, SOUNDMIXRATE, SOUNDBITS, SOUNDCHANS))
   {
      MsgBox("InitGameSound:Cdsound.Init - %s", Cdsound.ErrorToString());
      return 2;
   }
   
   return 0;
} /* InitGameSound */


void DeinitGameSound()
{
} /* DeinitGameSound */


int InitGameInput()
{
   int i;
   GUID guid;

   Cdinput.SetBufSize(INPUTBUFSIZE);

   if (Cdinput.Init(g_hWnd, g_hInst))
   {
      MsgBox("InitGame:Cdinput.Init - %s", Cdinput.ErrorToString());
      return 3;
   }
   
   /* DONT WANT MOUSE
   Cdmouse.Buffered = TRUE;
   Cdmouse.Callback = MouseCallback;
   if (Cdinput.InitDevice(&Cdmouse, CDI_MOUSE,
                          DISCL_NONEXCLUSIVE | DISCL_FOREGROUND, guid))
   {
      MsgBox("InitGame:Cdinput.InitDevice(MOUSE) - %s", Cdinput.ErrorToString());
      return 4;
   }
   MouseX = MouseY = 0;
   for(i=0;i<3;i++) MouseBtn[i] = 0;*/
      
   Cdkeyboard.Buffered = TRUE;
   Cdkeyboard.Callback = KBCallback;
   if (Cdinput.InitDevice(&Cdkeyboard, CDI_KEYBOARD,
                          DISCL_NONEXCLUSIVE | DISCL_FOREGROUND, guid))
   {
      MsgBox("InitGame:Cdinput.InitDevice(KB) - %s", Cdinput.ErrorToString());
      return 5;
   }
   for(i=0;i<256;i++) KeyboardBuf[i] = 0;
      
   if (Cdinput.InitThread())
   {
      MsgBox("InitGame:Cdinput.InitThread");
      return 6;
   }

   return 0;
} /* InitGameInput */


void DeinitGameInput()
{
   Cdinput.KillThread();
   Cdinput.KillDevice(&Cdkeyboard);
   Cdinput.KillDevice(&Cdmouse);
} /* DeinitGameInput */


int InitGameGraphics()
{
   if (Cgraph.Init(g_hWnd))
   {
      MsgBox("InitGame:Cgraph.Init - %s", Cgraph.ErrorToString());
      return 1;
   }

#ifdef WINDOWED   
   Cgraph.UpdateWindowed();
   if (Cgraph.SetMode(DISPLAYWIDTH, DISPLAYHEIGHT, DISPLAYDEPTH, CDD_WINDOWED, CDD_SINGLE))
#else
   if (Cgraph.SetMode(DISPLAYWIDTH, DISPLAYHEIGHT, DISPLAYDEPTH, CDD_FULLSCREEN, CDD_SINGLE))
#endif
   {
      MsgBox("InitGame:Cgraph.SetMode - %s", Cgraph.ErrorToString());
      return 11;
   }

   return 0;
} /* InitGameGraphics */


void DeinitGameGraphics()
{
   Cgraph.Deinit();
} /* DeinitGameGraphics */


void KBCallback(CDIDevice *dev)
{
   DIDEVICEOBJECTDATA dod[INPUTBUFSIZE];
   DWORD i, num = INPUTBUFSIZE;
   HRESULT hRet;
   KeyPress kp;

   if (dev == NULL)
   {
      bInputFailure = TRUE;
      return;
   }

   while(TRUE)
   {
      hRet = dev->pDIDev->GetDeviceData(sizeof(DIDEVICEOBJECTDATA), dod, &num, 0);
      if (hRet == DIERR_NOTACQUIRED || hRet == DIERR_INPUTLOST)
      {
         hRet = dev->pDIDev->Acquire();
         if (FAILED(hRet)) break;
      }
      else break;
   }
   if (FAILED(hRet))
   {
      bInputFailure = TRUE;
      return;
   }
   else bInputFailure = FALSE;
   
   if (!g_bEditFocus)
   {
      for(i=0;i<num;i++)
      {
         KeyboardBuf[dod[i].dwOfs] = dod[i].dwData & 0x80;
         kp.Key  = dod[i].dwOfs;
         kp.Down = dod[i].dwData & 0x80;
         KeyHistory.push_back(kp);
         if (KeyHistory.size() > KEYHISTORY) KeyHistory.pop_front();
      }
   }
} /* KBCallback */


void MouseCallback(CDIDevice *dev)
{
/*
   DIDEVICEOBJECTDATA dod[INPUTBUFSIZE];
   DWORD i, num = INPUTBUFSIZE;
   HRESULT hRet;
   MouseClick mc;
   BOOL fClick = FALSE;

   if (dev == NULL)
   {
      bInputFailure = TRUE;
      return;
   }

   while(TRUE)
   {
      hRet = dev->pDIDev->GetDeviceData(sizeof(DIDEVICEOBJECTDATA), dod, &num, 0);
      if (hRet == DIERR_NOTACQUIRED || hRet == DIERR_INPUTLOST)
      {
         hRet = dev->pDIDev->Acquire();
         if (FAILED(hRet)) break;
      }
      else break;
   }
   if (FAILED(hRet))
   {
      bInputFailure = TRUE;
      return;
   }
   else bInputFailure = FALSE;

   for(i=0;i<num;i++)
   {
      switch(dod[i].dwOfs)
      {
         case DIMOFS_X:
            MouseX += dod[i].dwData;
            break;

         case DIMOFS_Y:
            MouseY += dod[i].dwData;
            break;

         case DIMOFS_BUTTON1:
            mc.Down = MouseBtn[0] = dod[i].dwData & 0x80;
            mc.Btn  = 1;
            fClick  = TRUE;
            break;

         case DIMOFS_BUTTON2:
            mc.Down = MouseBtn[1] = dod[i].dwData & 0x80;
            mc.Btn  = 2;
            fClick  = TRUE;
            break;

         case DIMOFS_BUTTON3:
            mc.Down = MouseBtn[2] = dod[i].dwData & 0x80;
            mc.Btn  = 3;
            fClick  = TRUE;
            break;
      }
      if (fClick)
      {
         mc.X = MouseX;
         mc.Y = MouseY;
         if (mc.X < 0) mc.X = 0;
         if (mc.X >= DISPLAYWIDTH) mc.X = DISPLAYWIDTH - 1;
         if (mc.Y < 0) mc.Y = 0;
         if (mc.Y >= DISPLAYHEIGHT) mc.Y = DISPLAYHEIGHT - 1;
         ClickHistory.push_back(mc);
         if (ClickHistory.size() > CLICKHISTORY) ClickHistory.pop_front();
      }
   }

   if (MouseX < 0) MouseX = 0;
   if (MouseX >= DISPLAYWIDTH) MouseX = DISPLAYWIDTH - 1;
   if (MouseY < 0) MouseY = 0;
   if (MouseY >= DISPLAYHEIGHT) MouseY = DISPLAYHEIGHT - 1;
*/
} /* MouseCallback */
